package complex_operations;
import db_context.DbContext;
import db_context.MyExceptions;
import row_data_gateway.Transport;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class OtherOperations {

    private static final OtherOperations INSTANCE = new OtherOperations();
    public static OtherOperations getInstance() {
        return INSTANCE;
    }
    private OtherOperations() {
    }

    public BigDecimal countDeliveryPrice(int id) throws SQLException, MyExceptions.LogicException{
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT sum(weight) as summ FROM items WHERE package_id = ?")){
            s.setInt(1, id);
            try (ResultSet r = s.executeQuery()){
                if(r.next()) return r.getBigDecimal("summ");
                else throw new MyExceptions.LogicException("This package was already scheduled for transport");
            }
        }
    }

    public Integer findCustomerLocation(int customer_id) throws SQLException, MyExceptions.NotSuchIdException{
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT location_id FROM customers WHERE id = ?")){
            s.setInt(1, customer_id);
            try(ResultSet r = s.executeQuery()){
                if (r.next()) {
                    return r.getInt("location_id");
                } else {
                    throw new MyExceptions.NotSuchIdException("Not such person");
                }
            }
        }
    }

    public String findCustomerName(int customer_id) throws SQLException, MyExceptions.NotSuchIdException{
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT first_name, second_name FROM customers WHERE id = ?")){
            s.setInt(1, customer_id);
            try(ResultSet r = s.executeQuery()){
                if (r.next()) {
                    return r.getString(1) + " " + r.getString(2);
                } else {
                    throw new MyExceptions.NotSuchIdException("Not such person");
                }
            }
        }
    }

    public String findLocationNameById(int id) throws SQLException, MyExceptions.NotSuchIdException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT name FROM locations WHERE id = ?")){
            s.setInt(1, id);
            try (ResultSet r = s.executeQuery()) {
                if (r.next()) {
                    return r.getString("name");
                } else {
                    throw new MyExceptions.NotSuchIdException("Not such Location");
                }
            }
        }
    }

    public String translateRoute(String route) throws SQLException, MyExceptions.NotSuchIdException {
        String[] pole = route.substring(1, route.length()-1).split(",");
        String vysl = "";
        for(String i:pole){
            vysl += findLocationNameById(Integer.parseInt(i)) + " -> ";
        }
        return vysl.substring(0, vysl.length() - 4);
    }

    public Integer findLocationInConnections(int id) throws SQLException, MyExceptions.NotSuchIdException{
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT loca_id FROM connections WHERE id = ?")){
            s.setInt(1, id);
            try (ResultSet r = s.executeQuery()) {
                if(r.next()) {
                    return r.getInt("loca_id");
                }else{
                    throw new MyExceptions.NotSuchIdException("Not such connection");
                }
            }
        }
    }

    public Integer findConnectionFromLocations(int start, int end) throws SQLException, MyExceptions.NotSuchIdException{
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT id FROM connections WHERE loca_id = ? and locb_id = ?")){
            s.setInt(1, start);
            s.setInt(2, end);
            try(ResultSet r = s.executeQuery()){
                if(r.next()) {
                    return r.getInt("id");
                }else{
                    throw new MyExceptions.NotSuchIdException("This locations are not connected " + start + ", " + end);
                }
            }
        }
    }

    public boolean IsPersonReachable(int cus_id) throws SQLException, MyExceptions.NotSuchIdException{
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("select * from customers where id = ?")){
            s.setInt(1, cus_id);
            try (ResultSet r = s.executeQuery()) {
                if(r.next()){
                    return r.getBoolean("reachable");
                }else{
                    throw new MyExceptions.NotSuchIdException("No such customer");
                }
            }
        }
    }

    public String ReversePath(Transport transport){
        String[] path = transport.getRoute().substring(1, transport.getRoute().length()-1).split(",");
        String[] res = new String[path.length];
        for(int i = 0; i < path.length; i++){
            res[i] = path[path.length - i - 1];
        }
        return res.toString();
    }

    public String Adjust(String s, int n){
        String res = s;
        while(res.length() < n){
            res = " " + res + " ";
        }
        return res;
    }
}
